using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using ZedGraph;

namespace TempLog
{
    public partial class DataLogWav : Form
    {   GraphPane myPane;
        PointPairList list;
        LineItem myCurve;

        public DataLogWav()
        {
            InitializeComponent();
            myPane = zg1.GraphPane;
            

            // Set the titles and axis labels
            myPane.Title.Text = "Temperature Graph";
            myPane.XAxis.Title.Text = "Sample, Time";
            myPane.YAxis.Title.Text = "Temperature (C)";

            myPane.XAxis.Scale.MajorStep = 8;
            myPane.XAxis.Scale.MajorUnit = DateUnit.Second;

            // tilt the x axis labels to an angle of 65 degrees
            myPane.XAxis.Scale.FontSpec.Angle = 90;
            myPane.XAxis.Scale.FontSpec.IsBold = true;
            myPane.XAxis.Scale.FontSpec.Size = 10;
            myPane.XAxis.Scale.Format = "dd/MM/yy HH:mm:ss";
            // Set the XAxis to date type
            myPane.XAxis.Type = AxisType.Date;
            list = new PointPairList();
            myCurve = myPane.AddCurve("Temp",list, Color.Blue, SymbolType.Circle);
        }

        public void GraphLogBuild(PointPairList Samplelist)
        {
            double tMin, tMax;
            myPane.CurveList["Temp"].Clear();

            tMin = 1000;
            tMax = -1000;
            for (int i = 0; i < Samplelist.Count; i++)
            {
                list.Add(Samplelist[i].X, Samplelist[i].Y);
                if (Samplelist[i].Y < tMin)
                    tMin = Samplelist[i].Y;
                if (Samplelist[i].Y > tMax)
                    tMax = Samplelist[i].Y;
            }

            // Fill the symbols with Blue
            myCurve.Symbol.Fill = new Fill(Color.Blue);

            // Show the x axis grid
            myPane.XAxis.Scale.BaseTic = Samplelist[0].X;
            myPane.XAxis.MajorGrid.IsVisible = false;
            // Make the Y axis scale blue
            myPane.YAxis.Scale.FontSpec.FontColor = Color.Blue;
            myPane.YAxis.Title.FontSpec.FontColor = Color.Blue;
            // turn off the opposite tics so the Y tics don't show up on the Y2 axis
            myPane.YAxis.MajorTic.IsOpposite = false;
            myPane.YAxis.MinorTic.IsOpposite = false;
            // Don't display the Y zero line
            myPane.YAxis.MajorGrid.IsZeroLine = false;
            // Manually set the axis range
            myPane.YAxis.Scale.Min = (int)tMin - 5;
            myPane.YAxis.Scale.Max = (int)tMax + 5;
            // Align the Y axis labels so they are flush to the axis
            //myPane.YAxis.Scale.Align = AlignP.Inside;
            // Enable scrollbars if needed
            zg1.IsShowHScrollBar = false;
            zg1.IsShowVScrollBar = false;
            zg1.IsAutoScrollRange = true;
            // OPTIONAL: Show tooltips when the mouse hovers over a point
            zg1.IsShowPointValues = true;
            zg1.PointDateFormat = "dd/MM/yy HH:mm:ss";
            // Tell ZedGraph to calculate the axis ranges
            // Note that you MUST call this after enabling IsAutoScrollRange, since AxisChange() sets
            // up the proper scrolling parameters
            zg1.AxisChange();
            // Make sure the Graph gets redrawn
            zg1.Invalidate();
             
        }

        private void zg1_ZoomEvent(ZedGraphControl sender, ZoomState oldState, ZoomState newState)
        {
            int i;

            for ( i = 0; i < list.Count; i++)
            {
                if (list[i].X >= myPane.XAxis.Scale.Min) break;
            }
            myPane.XAxis.Scale.BaseTic = list[i].X;
            zg1.AxisChange();
        }
    }


}